/***************************************************************
 *                    simula.plus@cemes.fr                     *
 *                   GNU/linux version 3.2.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2012 COLLARD Christophe
 * copyright © 2012 Centre National de la Recherche Scientifique
 * copyright © 2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    gaussian_white_noise-test belongs to Mathematical Object Libraries (MOL++)
    MOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type gaussian_white_noise-test
#endif

#ifndef __gaussian_white_noise_test_hpp
#define __gaussian_white_noise_test_hpp


#ifndef __iostream
#include <iostream>
#endif

#ifndef __stdio_h
#include <stdio.h>
#endif

#ifndef __stdlib_h
#include <stdlib.h>
#endif

#ifndef __colors_hpp
#include "colors.hpp"
#endif

#ifndef __gaussian_white_noise_hpp
#include "MOL++/gaussian white noise.hpp"
#endif

#ifndef __matrix_hpp
#include "MOL++/matrix.hpp"
#endif

#ifndef __affiche_hpp
#include "tests/affiche.hpp"
#endif

using namespace std;
using namespace mol;


//========================================
int test_gaussian_white_noise (int detail)
//========================================
{
  int result=1;

  /* Generate a new random seed from system time - do this once in your constructor */

  int max = 1000000;
  matrix<long double> numbers (max, 1);
  srand ( time (NULL) );
  for (int i=1; i<=0.5*max; i++)
    { long double S = 1;
      long double U1, U2, V1, V2;
      for (; !S || S>=1;)
	{ U1 = rand () / (long double) RAND_MAX; /* U1=[0,1] */
	  U2 = rand () / (long double) RAND_MAX; /* U2=[0,1] */
	  V1 = 2 * U1 - 1; /* V1=[-1,1] */
	  V2 = 2 * U2 - 1; /* V2=[-1,1] */
	  S = V1 * V1 + V2 * V2;
	}

      long double X = sqrt (- 2 * log (S) / S) * V1;
      long double Y = sqrt (- 2 * log (S) / S) * V2;
      assert (Y != 0);
      numbers (i,1) = X;
      numbers (0.5*max+i,1) = Y;
    }

  numbers.save ("gaussian white noise.res");

  matrix<long double> numbers2 (max, 1);
  gaussian_white_noise<long double> points (max);
  numbers2 = points.get_all_numbers ();
  numbers2.save ("gaussian white noise2.res");

  system ("gnuplot 'data/gaussian-white-noise.gnuplot'");

  long double number;
  for (int i=1; i<=10; i++)
    number = points.get_random_number ();

  if (detail) affiche ("get random number", number == numbers2 (10,1));
  else result *= (number == numbers2 (10,1));

  cout << endl;

  cout << "============================================================== \n";
  if (result) cout << green << "             gaussian white noise test passed" << reset;
  else cout << red << "             gaussian white noise test failed" << reset;
  cout << "============================================================== \n";

  return result;
}


#endif
